

;;;function from cmpsys.lsp in Lisp Sources, xls-3-44 distribution
(defun compile-if-needed (file &optional (load t))
         (let ((lspfile (merge-pathnames file ".lsp"))
               (fslfile (merge-pathnames file ".fsl")))
           (unless (and (probe-file lspfile)
                        (probe-file fslfile)
                        (< (file-write-date lspfile)
                           (file-write-date fslfile)))
                   (compile-file file :load load))))

(def fde-lisp-files '("fde" "superscale" "plotline"))

(defun file-up-to-date-p (file)
     (let ((lspfile (merge-pathnames file ".lsp"))
           (fslfile (merge-pathnames file ".fsl")))
        (or (and (probe-file fslfile)
                 (not (probe-file lspfile)))
            (and (probe-file lspfile)
                 (probe-file fslfile)
                 (< (file-write-date lspfile)
                    (file-write-date fslfile))))))

(defun ask-to-compile (listy)
  (pprint listy)
  (when (ok-or-cancel-dialog
                   (format nil "~a files need compilation. Do it?"
                           (length listy)))
        (format t "~a~%" listy)
        (require "cmpload")
        (if (member "cmpload" *modules* :test #'string=)
            (mapcar #'compile-if-needed listy)
            (message-dialog "Compiler not found, please load it yourself"))))


(let* ((sources t) (needy nil))
 (dolist (fil fde-lisp-files)
     (unless (probe-file (merge-pathnames fil ".lsp"))
	     (format t "~a~%" (merge-pathnames fil ".lsp"))
             (setf sources nil)))
 (unless sources
   (message-dialog "Some sources not found. 
                    Currently compiled files will be used."))
 (setq needy (delete-if #'file-up-to-date-p
                              (copy-list fde-lisp-files)))
 (if needy
           (ask-to-compile needy)
           (message-dialog "No files need compilation")))


;;(mapcar #'compile-if-needed kde-lisp-files)




